/** @file   DatafileContainer.h
 * @brief   Declaration of DatafileItem class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/02/21 20:45:13 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_DATAFILECONTAINER_H
#define H_ENG2D_DATAFILECONTAINER_H

#include "GraphicsContainer.h"

namespace eng2d {

/** @class  DatafileContainer
 * @brief   A warehouse item that encapsulates an Allegro datafile.
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT DatafileContainer : public GraphicsContainer
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  DatafileContainer();

  /** Destructor
   */
  virtual ~DatafileContainer();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another DatafileItem
   */
  DatafileContainer( const DatafileContainer& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another DatafileItem
   * @return  Reference to this object.
   */
  DatafileContainer& operator= ( const DatafileContainer& aAnother );

public:
  
  ///
  /// Inherited methods
  /// =================

  /** From WarehouseItem.
   */
  virtual void ResetAndDestroy();
  
  /** From WarehouseItem. This method does nothing. The given object
   * is not deleted.
   */
  virtual void Push( void* aObject );
  
  /** From WarehouseItem.
   */
  virtual void* At(int aUid ) const;
  

  ///
  /// New public methods
  /// ==================

  /** Sets the datafile. The previous datafile will be unloaded.
   * @param   aDatafile         Pointer to new datafile.
   */
  void SetDatafile( DATAFILE* aDatafile );


  ///
  /// Getter methods
  /// ==============
  
  /** Returns a bitmap from this combine.
   * @param   aIndex            Index of the bitmap.
   * @return  Pointer to bitmap. Ownership is not transferred.
   */
  virtual BITMAP* GetBitmap( int aIndex ) const throw( xOutOfBounds, xLogicError );
  
  /** Returns a rle sprite from this combine.
   * @param   aIndex            Index of the rle sprite.
   * @return  Pointer to rle sprite. Ownership is not transferred.
   */
  virtual RLE_SPRITE* GetRleSprite( int aIndex ) const throw ( xOutOfBounds,
                                                               xLogicError );


protected:
  ///
  /// Protected interface
  /// ===================


protected:
  ///
  /// Data members
  /// ============
  
  /** Pointer to datafile. */
  DATAFILE* iDatafile;

  /** Number of elements the datafile has. */
  int iDatafileObjectCount;
};

};  // end of namespace

#endif
